import { jsxs, jsx } from "react/jsx-runtime";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { router } from "@inertiajs/react";
import { FilePenLine, TvMinimalPlay, FileText, Settings, CircleDollarSign, BookText, FolderInput, FlaskConical } from "lucide-react";
import { nanoid } from "nanoid";
import Assignment from "./assignment-DN0SQFNS.js";
import Basic from "./basic-gnBc5M_D.js";
import CourseUpdateHeader from "./course-update-header-C0EsT3Ml.js";
import Curriculum from "./curriculum-CgoHWCGZ.js";
import Info from "./info-3IgoJlgR.js";
import LiveClass from "./live-class-CygXgw34.js";
import Media from "./media-BNX5dv2Y.js";
import Pricing from "./pricing-Bz6jKuMj.js";
import SEO from "./seo-DZt1cLlP.js";
import Submissions from "./submissions-K_sxlpr1.js";
import "react";
import "@radix-ui/react-tabs";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./sidebar-4chFkdEZ.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./button-CoRGprmX.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-CP8LgHIG.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./card-DBOrqCcU.js";
import "./assignment-table-column-DdEQDzxR.js";
import "./badge-CnqJovSa.js";
import "./assignment-form-BYLinggN.js";
import "./datetime-picker-vvicdyd7.js";
import "react-day-picker";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./checkbox-DmVJz5lb.js";
import "@radix-ui/react-checkbox";
import "./dialog-Bzzm0V8u.js";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./inertia-BtwbgBI3.js";
import "richtor";
/* empty css                 */
import "./combobox-BCj7gyvQ.js";
import "cmdk";
import "./radio-group-B7ePM9gk.js";
import "@radix-ui/react-radio-group";
import "./textarea-M8ToDCeU.js";
import "./course-languages-oEC7DuVF.js";
import "./data-sort-modal-fNvcILsf.js";
import "nprogress";
import "./delete-modal-CTUf4WRn.js";
import "./lesson-form-BPub2Kwm.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "axios";
import "./file-metadata-CvVo69cP.js";
import "./question-questions-D2GrqPgL.js";
import "./question-form-B_RkYTpp.js";
import "./tag-input-9nM54QOY.js";
import "@yaireo/tagify";
import "./quiz-form-CjcnwfHb.js";
import "./section-form-Dh87huUv.js";
import "./resource-modal-vE3GMHxa.js";
import "./resource-form-e1xxyUlu.js";
import "./resource-list-ZMhElnQD.js";
import "./faq-form-CSw6fKSj.js";
import "./outcome-form-yCVRTfU5.js";
import "./requirement-form-LS1CUcPQ.js";
import "./live-class-form-Cs-aHLwp.js";
import "./live-class-status-B5j35Hn2.js";
import "./video-player-DbcUPn7s.js";
import "plyr-react";
/* empty css                */
import "./course-durations-Cq7bB4fL.js";
import "./table-filter-BKvPriu7.js";
import "./debounce-ZFxqVthq.js";
import "./table-page-size-CjbVFJnO.js";
import "./table-footer-Cfva3_5Y.js";
import "./submissions-table-column-CpHjiKL2.js";
import "./grade-submission-dialog-DlsWmySs.js";
import "./assignment-grade-form-4UR2niny.js";
const Update = (props) => {
  const { tab, assignment, course, translate } = props;
  const { button } = translate;
  const tabs = [
    {
      id: nanoid(),
      name: button.curriculum,
      slug: "curriculum",
      Icon: FilePenLine,
      Component: Curriculum
    },
    {
      id: nanoid(),
      name: button.live_class,
      slug: "live-class",
      Icon: TvMinimalPlay,
      Component: LiveClass
    },
    {
      id: nanoid(),
      name: "Assignment",
      slug: "assignment",
      Icon: FileText,
      Component: assignment ? Submissions : Assignment
    },
    {
      id: nanoid(),
      name: button.basic,
      slug: "basic",
      Icon: Settings,
      Component: Basic
    },
    {
      id: nanoid(),
      name: button.pricing,
      slug: "pricing",
      Icon: CircleDollarSign,
      Component: Pricing
    },
    {
      id: nanoid(),
      name: button.info,
      slug: "info",
      Icon: BookText,
      Component: Info
    },
    {
      id: nanoid(),
      name: button.media,
      slug: "media",
      Icon: FolderInput,
      Component: Media
    },
    {
      id: nanoid(),
      name: button.seo,
      slug: "seo",
      Icon: FlaskConical,
      Component: SEO
    }
  ];
  return /* @__PURE__ */ jsxs("section", { className: "space-y-8", children: [
    /* @__PURE__ */ jsx(CourseUpdateHeader, {}),
    /* @__PURE__ */ jsxs(Tabs, { value: tab ?? tabs[0].slug, className: "grid grid-rows-1 gap-5 md:grid-cols-4", children: [
      /* @__PURE__ */ jsx("div", { className: "col-span-full md:col-span-1", children: /* @__PURE__ */ jsx(TabsList, { className: "horizontal-tabs-list space-y-1", children: tabs.map(({ id, name, slug, Icon }) => /* @__PURE__ */ jsxs(
        TabsTrigger,
        {
          value: slug,
          className: "horizontal-tabs-trigger",
          onClick: () => router.get(
            route("courses.edit", {
              course: course.id,
              tab: slug
            })
          ),
          children: [
            /* @__PURE__ */ jsx(Icon, { className: "h-4 w-4" }),
            /* @__PURE__ */ jsx("span", { children: name })
          ]
        },
        id
      )) }) }),
      /* @__PURE__ */ jsx("div", { className: "col-span-full md:col-span-3", children: tabs.map(({ id, slug, Component }) => /* @__PURE__ */ jsx(TabsContent, { value: slug, className: "m-0", children: /* @__PURE__ */ jsx(Component, {}) }, id)) })
    ] })
  ] });
};
Update.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Update as default
};
